/* =====================================================
   基本設定
===================================================== */

// 変数宣言
const ballCount = 10;
const ballSpeed = 5;
const balls = [];

/* =====================================================
   DOM取得
===================================================== */
// 画面切替用
const playScreen = document.querySelector("#play");

// ボールとマリモ配置用
const ballDiv = document.querySelector("#ball");

// 画面サイズの取得
const maxX = playScreen.clientWidth;
const maxY = playScreen.clientHeight;
console.log(maxX, maxY);

/* =====================================================
   関数 / 生成処理
===================================================== */
// ボールを作成する関数
function makeBalls() {

  // ボールをfor文で生成
  for(let i = 0; i < ballCount; i++) {
    // ボール[i]を生成
    balls[i] = document.createElement("img");
    balls[i].src = "img/ball.png";
    balls[i].style.position = "absolute";
    balls[i].style.transform = "translate(-50%,-50%)";
    balls[i].style.width = "40px";
    balls[i].style.height = "40px";

    //ボール[i]を画面に追加
    ballDiv.appendChild(balls[i]);

    // ボール[i]の速度をランダムに設定（-5 〜 +5）
    let s = ballSpeed; // 最大速度
    balls[i].vX = Math.random() * s * 2 - s;
    balls[i].vY = Math.random() * s * 2 - s;

    // ボール[i]の座標をランダムに設定
    let r = balls[i].offsetWidth / 2; // 半径
    balls[i].posX = Math.random() * (maxX - r * 2 - s * 2) + r + s;
    balls[i].posY = Math.random() * (maxY - r * 2 - s * 2) + r + s;

  }

}

/* =====================================================
   関数 / 移動処理
===================================================== */
// ボールを動かす関数
function moveBalls() {
  // ボールをfor文で移動
  for(let i = 0; i < ballCount; i++) {
    // x座標を vX 増やす
    balls[i].posX = balls[i].posX + balls[i].vX;
    balls[i].posY = balls[i].posY + balls[i].vY;

    // 画面の左右の端で跳ね返る
    if (balls[i].posX > maxX - balls[i].offsetWidth / 2) {
      balls[i].posX = maxX - balls[i].offsetWidth / 2;
      balls[i].vX = -balls[i].vX;
    }
    if (balls[i].posX < balls[i].offsetWidth / 2) {
      balls[i].posX = balls[i].offsetWidth / 2;
      balls[i].vX = -balls[i].vX;
    }

    // 画面の上下の端で跳ね返る
    if (balls[i].posY > maxY - balls[i].offsetHeight / 2) {
      balls[i].posY = maxY - balls[i].offsetHeight / 2;
      balls[i].vY = -balls[i].vY;
    }
    if (balls[i].posY < balls[i].offsetHeight / 2) {
      balls[i].posY = balls[i].offsetHeight / 2;
      balls[i].vY = -balls[i].vY;
    }

    // 画面に反映
    balls[i].style.left = balls[i].posX + "px";
    balls[i].style.top = balls[i].posY + "px";
  }
}

/* =====================================================
   関数 / ループ処理
===================================================== */

function loop() {
  moveBalls();
}

/* =====================================================
   関数 / ゲーム進行
===================================================== */
// ボールを生成
makeBalls();

// ゲームループ開始
setInterval(loop, 20);