/* =====================================================
   基本設定
===================================================== */
// 変数宣言
let mode; // start, play, end, clear
let maxX; // 画面サイズ（幅）
let maxY; // 画面サイズ（高さ）

/* =====================================================
   DOM取得
===================================================== */
// 画面切替用
const startScreen = document.querySelector("#start");
const playScreen = document.querySelector("#play");
const endScreen = document.querySelector("#end");
const clearScreen = document.querySelector("#clear");


/* =====================================================
   関数 / 画面切替
===================================================== */

function showScreen(screenName) {

  // すべての画面からactiveクラスを除去
  startScreen.classList.remove("active");
  playScreen.classList.remove("active");
  endScreen.classList.remove("active");
  clearScreen.classList.remove("active");

  // 指定された画面だけactiveクラスを追加
  if (screenName === "start") {
    startScreen.classList.add("active");
    maxX = startScreen.clientWidth;
    maxY = startScreen.clientHeight;

  } else if (screenName === "play") {
    playScreen.classList.add("active");
    maxX = playScreen.clientWidth;
    maxY = playScreen.clientHeight;

  } else if (screenName === "end") {
    endScreen.classList.add("active");
    maxX = endScreen.clientWidth;
    maxY = endScreen.clientHeight;

  } else if (screenName === "clear") {
    clearScreen.classList.add("active");
    maxX = clearScreen.clientWidth;
    maxY = clearScreen.clientHeight;

  }

  console.log(maxX, maxY);
  
  // モードを更新
  mode = screenName;

}

// 初期画面を表示
showScreen("play");