/* ==========================================
 * #2 マリモを動かす！
 * issue date: 2025.12.01
 * version:1.0
 * ========================================== */

/* =====================================================
   基本設定
===================================================== */

// 変数宣言
let marimo;

/* =====================================================
   DOM取得
===================================================== */

// 画面切替用
const playScreen = document.querySelector("#play");

// ボールとマリモ配置用
const marimoDiv = document.querySelector("#marimo");

// 画面サイズの取得
const maxX = playScreen.clientWidth;
const maxY = playScreen.clientHeight;
console.log(maxX, maxY);


/* =====================================================
   関数 / 生成処理
===================================================== */

// マリモを作成する関数
function makeMarimo() {
  // マリモを生成
  marimo = document.createElement("img");
  marimo.src = "img/marimo.png";
  marimo.style.position = "absolute";
  marimo.style.transform = "translate(-50%,-50%)";
  marimo.style.width = "70px";
  marimo.style.height = "70px";

  // マリモを画面に追加
  marimoDiv.appendChild(marimo);

  // マリモの座標
  marimo.posX = maxX * 0.5; // 中央に配置
  marimo.posY = maxY * 0.8; // 画面下部に配置
  
  // マリモの移動速度
  marimo.vX = 0;
  marimo.vY = 0;
  
}

/* =====================================================
   関数 / 移動処理
===================================================== */
// マリモを移動させる関数
function moveMarimo() {

  // 座標を移動させる
  marimo.posX = marimo.posX + marimo.vX;
  marimo.posY = marimo.posY + marimo.vY;

  // 画面の左右の端で止まる
  if (marimo.posX > maxX - marimo.offsetWidth / 2) {
    marimo.posX = maxX - marimo.offsetWidth / 2;
  }
  if (marimo.posX < marimo.offsetWidth / 2) {
    marimo.posX = marimo.offsetWidth / 2;
  }

  // 画面の上下の端で止まる //★
  if (marimo.posY > maxY - marimo.offsetHeight / 2) {
    marimo.posY = maxY - marimo.offsetHeight / 2;
  }
  if (marimo.posY < marimo.offsetHeight / 2) {
    marimo.posY = marimo.offsetHeight / 2;
  }

  // マリモの位置を設定
  marimo.style.left = marimo.posX + "px";
  marimo.style.top = marimo.posY + "px";
} 


/* =====================================================
   関数 / ループ処理
===================================================== */

function loop() {
  moveMarimo();
}


/* =====================================================
   関数 / ゲーム進行
===================================================== */
// マリモを生成
makeMarimo();

// ゲームループ開始
setInterval(loop, 20);


/* =====================================================
   キーボード操作
===================================================== */
// キーボードのキーを押したときの処理
function onKeyDown(e) {

  // ブラウザのデフォルト動作を止める
  e.preventDefault();

  console.log(e.code);

  // 左右上下移動
  if (e.code === "ArrowLeft") {
    marimo.vX = -5;
    marimo.src = 'img/marimo_L.png';
  } else if (e.code === "ArrowRight") {
    marimo.vX = 5;
    marimo.src = 'img/marimo_R.png';
  } else if (e.code === "ArrowUp") {
    marimo.vY = -5;
    marimo.src = 'img/marimo_U.png';
  } else if (e.code === "ArrowDown") {
    marimo.vY = 5;
    marimo.src = 'img/marimo.png';
  }
}

// キーボードのキーを離したときの処理
function onKeyUp(e) {

  // ブラウザのデフォルト動作を止める
  e.preventDefault();

  // 左右上下移動
  if (e.code === "ArrowLeft") {
    marimo.vX = 0;
    marimo.src = 'img/marimo.png';
  } else if (e.code === "ArrowRight") {
    marimo.vX = 0;
    marimo.src = 'img/marimo.png';
  } else if (e.code === "ArrowUp") {
    marimo.vY = 0;
    marimo.src = 'img/marimo.png';
  } else if (e.code === "ArrowDown") {
    marimo.vY = 0;
    marimo.src = 'img/marimo.png';
  }
}

// keydownイベント
document.addEventListener('keydown', onKeyDown);
// keyupイベント
document.addEventListener('keyup', onKeyUp);
