/* =====================================================
   基本設定
===================================================== */
// 変数宣言

let mode; // start, play, end, clear
let maxX; // 画面サイズ（幅）
let maxY; // 画面サイズ（高さ）

/* =====================================================
   DOM取得
===================================================== */
// 画面切替用
const startScreen = document.querySelector("#start");
const playScreen = document.querySelector("#play");
const endScreen = document.querySelector("#end");
const clearScreen = document.querySelector("#clear");

// ボールとマリモ配置用
// ライフなど情報表示用


/* =====================================================
   関数 / 生成処理
===================================================== */
// マリモを作成する関数 / makeMarimo() {}
// ボールを作成する関数 / makeBalls() {}


/* =====================================================
   関数 / 移動処理
===================================================== */
// マリモを動かす関数 / moveMarimo() {}
// ボールを動かす関数 / moveBalls() {}


/* =====================================================
   関数 / ゲームロジック
===================================================== */
// ★当たり判定を行う関数/ checkHit() {}
// ★当たった時の処理を行う関数（ライフを減らす）  / onHit() {}
// ★タイマーを更新する関数/ gameTimer() {}


/* =====================================================
   関数 / 画面切替
===================================================== */
// 画面表示を切り替える関数 / showScreen() {}
function showScreen(screenName) {

  // すべての画面からactiveクラスを除去
  startScreen.classList.remove("active");
  playScreen.classList.remove("active");
  endScreen.classList.remove("active");
  clearScreen.classList.remove("active");

  // 指定された画面だけactiveクラスを追加
  if (screenName === "start") {
    startScreen.classList.add("active");
    maxX = startScreen.clientWidth;
    maxY = startScreen.clientHeight;

  } else if (screenName === "play") {
    playScreen.classList.add("active");
    maxX = playScreen.clientWidth;
    maxY = playScreen.clientHeight;

  } else if (screenName === "end") {
    endScreen.classList.add("active");
    maxX = endScreen.clientWidth;
    maxY = endScreen.clientHeight;

  } else if (screenName === "clear") {
    clearScreen.classList.add("active");
    maxX = clearScreen.clientWidth;
    maxY = clearScreen.clientHeight;

  }

  console.log(maxX, maxY);
  
  // モードを更新
  mode = screenName;

}

/* =====================================================
   関数 / ループ処理
===================================================== */
// ループ関数 / loop() {}


/* =====================================================
   関数 / ゲーム進行
===================================================== */
function startMode() {
  // 画面表示 / showScreen();
  showScreen("start");
}

function playMode() {
  // 変数をリセット
  // 表示をリセット
  // タイマー開始時刻を設定
  // 画面表示 / showScreen();
  showScreen("play");
  // マリモを生成 / makeMarimo();
  // ボールを生成 / makeBalls();
  // ゲームループ開始 / setInterval();
}

function endMode() {
  // ゲームループの停止 / clearInterval();
  // 画面表示 / showScreen();
  showScreen("end");
}

function clearMode() {
  // ゲームループの停止 / clearInterval();
  // 画面表示 / showScreen();
  showScreen("clear");

}


/* =====================================================
   初期実行
===================================================== */
// ★ゲーム起動 / startMode();
startMode();
//playMode();
//endMode();
//clearMode();

/* =====================================================
   キーボード操作
===================================================== */
// keydown関数/ function onKeyDown(e) {}
// keyup関数/ function onKeyUp (e) {}
// keydownイベント / addEventListener
// keyupイベント/ addEventListener