/* =====================================================
   基本設定
===================================================== */
// 変数宣言

let mode; // start, play, end, clear
let maxX; // 画面幅
let maxY; // 画面高さ
let marimo; // マリモの変数

/* =====================================================
   DOM取得
===================================================== */
// 画面切替用
const startScreen = document.querySelector("#start");
const playScreen = document.querySelector("#play");
const endScreen = document.querySelector("#end");
const clearScreen = document.querySelector("#clear");

// ボールとマリモ配置用
const marimoDiv = document.querySelector("#marimo");

// ライフなど情報表示用



/* =====================================================
   関数 / 生成処理
===================================================== */
// マリモを作成する関数
function makeMarimo() {
  // マリモを生成
  marimo = document.createElement("img");
  marimo.src = "img/marimo.png";
  marimo.style.position = "absolute";
  marimo.style.transform = "translate(-50%,-50%)";
  marimo.style.width = "70px";
  marimo.style.height = "70px";

  // マリモを画面に追加
  marimoDiv.appendChild(marimo);

  // マリモの座標
  marimo.posX = maxX * 0.5; // 中央に配置
  marimo.posY = maxY * 0.8; // 画面下部に配置
  
  // マリモの移動速度
  marimo.vX = 0;
  marimo.vY = 0;
  
}
// ボールを作成する関数 / makeBalls() {}


/* =====================================================
   関数 / 移動処理
===================================================== */
// マリモを移動させる関数
function moveMarimo() {

  // 座標を移動させる
  marimo.posX = marimo.posX + marimo.vX;
  marimo.posY = marimo.posY + marimo.vY;

  // 画面の左右の端で止まる
  if (marimo.posX > maxX - marimo.offsetWidth / 2) {
    marimo.posX = maxX - marimo.offsetWidth / 2;
  }
  if (marimo.posX < marimo.offsetWidth / 2) {
    marimo.posX = marimo.offsetWidth / 2;
  }

  // 画面の上下の端で止まる //★
  if (marimo.posY > maxY - marimo.offsetHeight / 2) {
    marimo.posY = maxY - marimo.offsetHeight / 2;
  }
  if (marimo.posY < marimo.offsetHeight / 2) {
    marimo.posY = marimo.offsetHeight / 2;
  }

  // マリモの位置を設定
  marimo.style.left = marimo.posX + "px";
  marimo.style.top = marimo.posY + "px";
}
// ボールを動かす関数 / moveBalls() {}


/* =====================================================
   関数 / ゲームロジック
===================================================== */
// ★当たり判定を行う関数/ checkHit() {}
// ★当たった時の処理を行う関数（ライフを減らす）  / onHit() {}
// ★タイマーを更新する関数/ gameTimer() {}


/* =====================================================
   関数 / 画面切替
===================================================== */
// 画面表示を切り替える関数 / showScreen() {}
function showScreen(screenName) {

  // すべての画面からactiveクラスを除去
  startScreen.classList.remove("active");
  playScreen.classList.remove("active");
  endScreen.classList.remove("active");
  clearScreen.classList.remove("active");

  // 指定された画面だけactiveクラスを追加
  if (screenName === "start") {
    startScreen.classList.add("active");
    maxX = startScreen.clientWidth;
    maxY = startScreen.clientHeight;

  } else if (screenName === "play") {
    playScreen.classList.add("active");
    maxX = playScreen.clientWidth;
    maxY = playScreen.clientHeight;

  } else if (screenName === "end") {
    endScreen.classList.add("active");
    maxX = endScreen.clientWidth;
    maxY = endScreen.clientHeight;

  } else if (screenName === "clear") {
    clearScreen.classList.add("active");
    maxX = clearScreen.clientWidth;
    maxY = clearScreen.clientHeight;

  }

  console.log(maxX, maxY);
  
  // モードを更新
  mode = screenName;

}

/* =====================================================
   関数 / ループ処理
===================================================== */
// ループ関数 / loop() {}
function loop() {
  moveMarimo();
}


/* =====================================================
   関数 / ゲーム進行
===================================================== */
function startMode() {
  // 画面表示 / showScreen();
  showScreen("start");
}

function playMode() {
  // 変数をリセット
  // 表示をリセット
  // タイマー開始時刻を設定
  // 画面表示
  showScreen("play");
  // マリモを生成
  makeMarimo();
  // ボールを生成 / makeBalls();
  // ゲームループ開始
  setInterval(loop, 20);
}

function endMode() {
  // ゲームループの停止 / clearInterval();
  // 画面表示 / showScreen();
  showScreen("end");
}

function clearMode() {
  // ゲームループの停止 / clearInterval();
  // 画面表示 / showScreen();
  showScreen("clear");

}


/* =====================================================
   初期実行
===================================================== */
// ★ゲーム起動 / startMode();
//startMode();
playMode();
//endMode();
//clearMode();

/* =====================================================
   キーボード操作
===================================================== */
// キーボードのキーを押したときの処理
function onKeyDown(e) {

  // ブラウザのデフォルト動作を止める
  e.preventDefault();
  
  // プレイ画面
  if (mode === "play") {
    // 左右上下移動
    if (e.code === "ArrowLeft") {
      marimo.vX = -5;
      marimo.src = 'img/marimo_L.png';
    } else if (e.code === "ArrowRight") {
      marimo.vX = 5;
      marimo.src = 'img/marimo_R.png';
    } else if (e.code === "ArrowUp") {
      marimo.vY = -5;
      marimo.src = 'img/marimo_U.png';
    } else if (e.code === "ArrowDown") {
      marimo.vY = 5;
      marimo.src = 'img/marimo.png';
    }
  }
}

// キーボードのキーを離したときの処理
function onKeyUp(e) {

  // ブラウザのデフォルト動作を止める
  e.preventDefault();

  // プレイ画面
  if (mode === "play") {
    // 左右上下移動
    if (e.code === "ArrowLeft") {
      marimo.vX = 0;
      marimo.src = 'img/marimo.png';
    } else if (e.code === "ArrowRight") {
      marimo.vX = 0;
      marimo.src = 'img/marimo.png';
    } else if (e.code === "ArrowUp") {
      marimo.vY = 0;
      marimo.src = 'img/marimo.png';
    } else if (e.code === "ArrowDown") {
      marimo.vY = 0;
      marimo.src = 'img/marimo.png';
    }
  }
}

// keydownイベント
document.addEventListener('keydown', onKeyDown);
// keyupイベント
document.addEventListener('keyup', onKeyUp);
